<?php
/* --------------------------------------------------------------
 Application.php 2020-05-04
 Gambio GmbH
 http://www.gambio.de
 Copyright (c) 2019 Gambio GmbH
 Released under the GNU General Public License (Version 2)
 [http://www.gnu.org/licenses/gpl-2.0.html]
 --------------------------------------------------------------
 */

declare(strict_types=1);

namespace Gambio\Core\Application;

use Gambio\Core\Application\Kernel\Bootstrapper;
use Gambio\Core\Application\Kernel\Kernel;
use League\Container\Container;

/**
 * Class Application
 * @package Gambio\Core\Application
 */
class Application extends Container
{
    public const VERSION = '4.1.1.0';
    
    
    /**
     * Main function.
     * Similar to other programming languages than php, we use this method as the applications entry point.
     *
     * @param Kernel       $kernel
     * @param Bootstrapper $bootstrapper
     */
    public static function main(Kernel $kernel, Bootstrapper $bootstrapper): void
    {
        $app = new static();
        $app->defaultToShared();
        
        $kernel->bootstrap($app, $bootstrapper);
        $kernel->run();
    }
}